//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "ModuleConfigForm.h"
#include "VisasmConfig.h"
#include "inifiles.hpp"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TModulePathForm *ModulePathForm;
//---------------------------------------------------------------------------
__fastcall TModulePathForm::TModulePathForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TModulePathForm::OKButtonClick(TObject *Sender)
{
  TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
  try
  {
    IniFile->WriteString("Main", "Modules", BaseModuleEdit->Text);
    IniFile->WriteString("Defaults", "API", APIEdit->Text);
    IniFile->WriteString("Defaults", "ASM", ASMEdit->Text);
    IniFile->WriteString("Defaults", "C", CEdit->Text);
    IniFile->WriteString("Defaults", "Library", LibraryEdit->Text);
    IniFile->WriteString("Defaults", "Int", INTEdit->Text);
    IniFile->WriteString("Defaults", "Opcodes", OpcodeEdit->Text);
  }
  catch( ... )
  {
    IniFile->Free();
    throw;
  }
  IniFile->Free();

  Close();
}
//---------------------------------------------------------------------------
void __fastcall TModulePathForm::CancelButtonClick(TObject *Sender)
{
  Close();
}


//---------------------------------------------------------------------------
void __fastcall TModulePathForm::FormCreate(TObject *Sender)
{
  String ModulePath;

  TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
  try
  {
    if (Form1->DirInfo.BasePath != "") ModulePath = Form1->DirInfo.BasePath;
    else ModulePath = ExtractFilePath(Application->ExeName) + "\Modules\\";  // no ini yet, make life easy !



    if (Form1->AssemblerInfo.Assembler != "") ModulePath = ModulePath + Form1->AssemblerInfo.Assembler;
    else ModulePath = ModulePath + "TASM\\";  // no ini yet, take TASM as default assembler


    BaseModuleEdit->Text = ModulePath;
    APIEdit->Text = IniFile->ReadString( "Defaults", "API", (ModulePath + "\API\\") );
    ASMEdit->Text = IniFile->ReadString( "Defaults", "ASM", (ModulePath + "\ASM\\") );
    CEdit->Text = IniFile->ReadString( "Defaults", "C", (ModulePath  + "\C\\") );
    INTEdit->Text = IniFile->ReadString( "Defaults", "Int", (ModulePath  + "\Int\\")  );
    LibraryEdit->Text = IniFile->ReadString( "Defaults", "Library", (ModulePath  + "\Library\\"));
    OpcodeEdit->Text = IniFile->ReadString( "Defaults", "Opcodes", (ModulePath  + "\Opcodes\\"));
  }
   catch( ... )
   {
     IniFile->Free();
     throw;
   }
   IniFile->Free();
}

//---------------------------------------------------------------------------
